/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.loot;

import com.google.gson.JsonObject;
import dev.ftb.ftbsbc.tools.ToolsTags;
import dev.ftb.ftbsbc.tools.recipies.CrookDropsResult;
import dev.ftb.ftbsbc.tools.recipies.ToolsRecipeCache;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CrookModifier
extends LootModifier {
    public CrookModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> list, LootContext context) {
        ItemStack crook = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (!(entity instanceof Player && crook != null && blockState != null && crook.m_204117_(ToolsTags.Items.CROOKS) && ToolsRecipeCache.crookable(blockState))) {
            return list;
        }
        CrookDropsResult crookDrops = ToolsRecipeCache.getCrookDrops(entity.f_19853_, new ItemStack((ItemLike)blockState.m_60734_()));
        if (crookDrops.items().size() > 0) {
            Random random = context.m_78933_();
            List collect = crookDrops.items().stream().filter(itemWithChance -> (double)random.nextFloat() < itemWithChance.chance()).map(itemWithChance -> itemWithChance.item().m_41777_()).collect(Collectors.toList());
            Collections.shuffle(collect);
            return collect.stream().limit(crookDrops.max()).toList();
        }
        return list;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<CrookModifier> {
        public CrookModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new CrookModifier(conditions);
        }

        public JsonObject write(CrookModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

